/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.TreeMap;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAccount;
import org.compiere.model.MElementValue;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.Query;
import org.compiere.model.X_M_Product_Acct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

@Process
public class ExpenseTypesFromAccounts
extends SvrProcess {
    private int m_clientId;
    private int m_acctSchemaId;
    private int m_priceListId;
    private String m_productValuePrefix = "";
    private String m_productValueSuffix = "";
    private String m_startElement;
    private String m_endElement;
    private int m_productCategoryId;
    private int m_taxCategoryId;
    private int m_uomId;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_Category_ID")) {
                    this.m_productCategoryId = para[i].getParameterAsInt();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.m_acctSchemaId = para[i].getParameterAsInt();
                } else if (name.equals("M_PriceList_ID")) {
                    this.m_priceListId = para[i].getParameterAsInt();
                } else if (name.equals("C_UOM_ID")) {
                    this.m_uomId = para[i].getParameterAsInt();
                } else if (name.equals("C_TaxCategory_ID")) {
                    this.m_taxCategoryId = para[i].getParameterAsInt();
                } else if (name.equals("ProductValuePrefix")) {
                    this.m_productValuePrefix = para[i].getParameter().toString();
                } else if (name.equals("ProductValueSuffix")) {
                    this.m_productValueSuffix = para[i].getParameter().toString();
                } else if (name.equals("StartElement")) {
                    this.m_startElement = para[i].getParameter().toString();
                } else if (name.equals("EndElement")) {
                    this.m_endElement = para[i].getParameter().toString();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MPriceList priceList = new MPriceList(this.getCtx(), this.m_priceListId, this.get_TrxName());
        this.m_clientId = priceList.getAD_Client_ID();
        MPriceListVersion pv = priceList.getPriceListVersion(null);
        if (pv == null) {
            throw new Exception("Pricelist " + priceList.getName() + " has no default version.");
        }
        List products = new Query(this.getCtx(), "M_Product", "ProductType=?", this.get_TrxName()).setParameters(new Object[]{"E"}).list();
        TreeMap<String, MProduct> productMap = new TreeMap<String, MProduct>();
        for (MProduct product : products) {
            productMap.put(product.getValue(), product);
        }
        List validCombs = new Query(this.getCtx(), "C_ValidCombination", "C_AcctSchema_ID=? and AD_Client_ID=? and AD_Org_ID=0", this.get_TrxName()).setParameters(new Object[]{this.m_acctSchemaId, this.m_clientId}).list();
        TreeMap<Integer, MAccount> validCombMap = new TreeMap<Integer, MAccount>();
        for (MAccount validComb : validCombs) {
            validCombMap.put(validComb.getAccount_ID(), validComb);
        }
        List result = new Query(this.getCtx(), "C_ElementValue", "AccountType=? and isSummary='N' and Value>=? and Value<=? and AD_Client_ID=?", this.get_TrxName()).setParameters(new Object[]{"E", this.m_startElement, this.m_endElement, this.m_clientId}).list();
        BigDecimal zero = Env.ZERO;
        int addCount = 0;
        int skipCount = 0;
        for (MElementValue elem : result) {
            MProduct product;
            String expenseItemValue = this.m_productValuePrefix + elem.getValue() + this.m_productValueSuffix;
            product = (MProduct)productMap.get(expenseItemValue);
            if (product == null) {
                MAccount validComb;
                product = new MProduct(this.getCtx(), 0, this.get_TrxName());
                product.set_ValueOfColumn("AD_Client_ID", (Object)this.m_clientId);
                product.setValue(expenseItemValue);
                product.setName(elem.getName());
                product.setDescription(elem.getDescription());
                product.setIsActive(true);
                product.setProductType("E");
                product.setM_Product_Category_ID(this.m_productCategoryId);
                product.setC_UOM_ID(this.m_uomId);
                product.setC_TaxCategory_ID(this.m_taxCategoryId);
                product.setIsStocked(false);
                product.setIsPurchased(true);
                product.setIsSold(false);
                product.saveEx(this.get_TrxName());
                MProductPrice priceRec = new MProductPrice(this.getCtx(), pv.get_ID(), product.get_ID(), this.get_TrxName());
                priceRec.set_ValueOfColumn("AD_Client_ID", (Object)this.m_clientId);
                priceRec.setPrices(zero, zero, zero);
                priceRec.saveEx(this.get_TrxName());
                validComb = (MAccount)validCombMap.get(elem.getC_ElementValue_ID());
                if (validComb == null) {
                    validComb = new MAccount(this.getCtx(), 0, this.get_TrxName());
                    validComb.set_ValueOfColumn("AD_Client_ID", (Object)this.m_clientId);
                    validComb.setAD_Org_ID(0);
                    validComb.setAlias(elem.getValue());
                    validComb.setAccount_ID(elem.get_ID());
                    validComb.setC_AcctSchema_ID(this.m_acctSchemaId);
                    validComb.saveEx(this.get_TrxName());
                }
                X_M_Product_Acct productAcct = (X_M_Product_Acct)new Query(this.getCtx(), "M_Product_Acct", "M_Product_ID=? and C_AcctSchema_ID=?", this.get_TrxName()).setParameters(new Object[]{product.get_ID(), this.m_acctSchemaId}).first();
                productAcct.setP_Expense_Acct(validComb.get_ID());
                productAcct.setP_Revenue_Acct(validComb.get_ID());
                productAcct.saveEx(this.get_TrxName());
                ++addCount;
                continue;
            }
            ++skipCount;
        }
        StringBuilder returnStr = new StringBuilder().append(addCount).append(" products added.");
        if (skipCount > 0) {
            returnStr.append(" ").append(skipCount).append(" products skipped.");
        }
        return returnStr.toString();
    }
}

